<script type="text/javascript">
    $(function(){
        'use strict';

        var device_params = {
            "client_filter": "[name='client_filter']",
            "devices_filter": "[name='devices_filter']",
            "model_filter": "[name='model_filter']",
            "status_filter": "[name='status_filter']",
        };
        var device_table = $('table.table-device_table');
        var _table_api = initDataTable(device_table, admin_url+'workshop/device_table', [0], [0], device_params, ['1', 'asc']);
        var hidden_columns = [0];
        $('.table-device_table').DataTable().columns(hidden_columns).visible(false, false);

        $('.table-device_table').on('draw.dt', function () {
            $(window).trigger('resize');
        });

        $.each(device_params, function(i, obj) {
            $('select' + obj).on('change', function() {  
                $('.table-device_table').DataTable().ajax.reload();
                filter_grid();
            });
        });

    });

    function check_load_more_visibility() {
        if($('.device-card-item.hide').length == 0) {
            $('#load-more-container').addClass('hide');
        } else {
            $('#load-more-container').removeClass('hide');
        }
    }

    var current_view = 'grid';

    function switch_view(view) {
        console.log('switch_view called with:', view);
        current_view = view;
        var loadMoreBtn = $('#load-more-container');
        var gridView = $('#device-grid-view');
        var listView = $('#device-list-view');

        if(view == 'grid'){
            listView.addClass('hide');
            gridView.removeClass('hide');
            
            $('#btn-grid-view').addClass('active');
            $('#btn-list-view').removeClass('active');
            
            // Re-evaluate grid state
            filter_grid(); 
            // Double check visibility
            check_load_more_visibility();
        } else {
            gridView.addClass('hide');
            
            listView.removeClass('hide');
            $('#btn-list-view').addClass('active');
            $('#btn-grid-view').removeClass('active');
            
            loadMoreBtn.addClass('hide'); 
        }
    }

    function load_more_devices() {
        var hidden_devices = $('.device-card-item.hide');
        // Show next 16
        hidden_devices.slice(0, 16).removeClass('hide');
        
        // If no more hidden devices, hide the button
        if($('.device-card-item.hide').length == 0) {
            $('#load-more-container').addClass('hide');
        }
    }

    function filter_grid() {
        var getSafeValue = function(name) {
            var val = $('select[name="' + name + '"]').val();
            return (val === null || val === undefined) ? '' : val.toString();
        };

        var client_id = getSafeValue('client_filter');
        var device_id = getSafeValue('devices_filter');
        var model_id = getSafeValue('model_filter');
        var status = getSafeValue('status_filter');

        var has_filter = (client_id !== '' || device_id !== '' || model_id !== '' || status !== '');

        if(has_filter) {
            // If filtering, hide the load more button and show all matching items
            $('#load-more-container').addClass('hide');
             $('.device-card-item').each(function() {
                var match = true;
                
                // Use attr to get the string value exactly as rendered
                if(client_id !== '' && $(this).attr('data-client-id') != client_id) match = false;
                if(device_id !== '' && $(this).attr('data-device-id') != device_id) match = false;
                if(model_id !== '' && $(this).attr('data-model-id') != model_id) match = false;
                if(status !== '' && $(this).attr('data-status') != status) match = false;
                
                if(match) $(this).removeClass('hide');
                else $(this).addClass('hide');
             });
        } else {
            // If filters cleared, reset to initial state (Show first 16)
            var count = 0;
            $('.device-card-item').each(function() {
                count++;
                if(count <= 16) $(this).removeClass('hide');
                else $(this).addClass('hide');
            });
            
            if($('.device-card-item').length > 16) {
                $('#load-more-container').removeClass('hide');
            } else {
                $('#load-more-container').addClass('hide');
            }
        }
    }

    function device_modal(device_id) {
        "use strict";

        $("#modal_wrapper").load("<?php echo admin_url('workshop/load_device_modal'); ?>", {
          device_id: device_id,
      }, function() {
          $("body").find('#deviceModal').modal({ show: true, backdrop: 'static' });
          init_selectpicker();
          init_datepicker();

      });

    }

    function delete_device(id) {
        "use strict";

        if (confirm_delete()) {
            $.post(admin_url + "workshop/delete_device/" + id).done(function (response) {
                response = JSON.parse(response);

                if (response.success === true || response.success == "true") {
                    alert_float('success', response.message)
                    $('.table-device_table').DataTable().ajax.reload();
                }
            });
        }
    }

    function delete_device_attachment(wrapper, attachment_id) {
        "use strict";  

        if (confirm_delete()) {
            $.get(admin_url + 'workshop/delete_device_attachment/' +attachment_id, function (response) {
                if (response.success == true) {
                    $(wrapper).parents('.dz-preview').remove();

                    var totalAttachmentsIndicator = $('.dz-preview'+attachment_id);
                    var totalAttachments = totalAttachmentsIndicator.text().trim();

                    if(totalAttachments == 1) {
                        totalAttachmentsIndicator.remove();
                    } else {
                        totalAttachmentsIndicator.text(totalAttachments-1);
                    }
                    alert_float('success', "<?php echo _l('wshop_deleted_device_image_successfully') ?>");

                } else {
                    alert_float('danger', "<?php echo _l('wshop_deleted_device_image_failed') ?>");
                }
            }, 'json');
        }
        return false;
    }

</script>